/**
* \file: IConfiguration.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: AAUTO
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <stdlib.h>
#include <limits.h>
#include <inttypes.h>
#include <adit_logging.h>
#include "IConfiguration.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto
{

IConfiguration::IConfiguration()
{
}

std::string IConfiguration::GetItem(const std::string& key, const std::string& defaultValue) const
{
    std::string item;
    if (!TryGetItem(key, item))
    {
        LOG_WARN((demo, "config item %s not found, default to \"%s\"", key.c_str(),
                defaultValue.c_str()));
        return defaultValue;
    }

    return item;
}

int64_t IConfiguration::GetNumber(const std::string& key, int64_t defaultValue) const
{
    int64_t result = defaultValue;

    std::string item;
    if (TryGetItem(key, item))
    {
        char* p = nullptr;
        int64_t converted = strtoll((const char *)item.c_str(), &p, 0);

        if ((converted == LLONG_MAX || converted == LLONG_MIN) && errno == ERANGE)
        {
            LOG_WARN((demo, "config item %s is out of range, default to %" PRId64 "", key.c_str(),
                    defaultValue));
            result = defaultValue;
        }
        else if (p != nullptr && *p != '\0')
        {
            LOG_WARN((demo, "config item %s is not a number, default to %" PRId64 "", key.c_str(),
                    defaultValue));
            result = defaultValue;
        }
        else
        {
            result = converted;
        }
    }
    else
    {
        LOG_WARN((demo, "IConfiguration::GetNumber: Item not found"));
    }

    return result;
}

void IConfiguration::GetNodeItem(const std::string& inNodeItem, std::string& outKey, std::string& outValue)
{
    // get key item from node
    outKey = GetKey(inNodeItem);
    if (!outKey.empty())
    {
        // found key. get value item from node
        outValue = GetValue(inNodeItem.substr(outKey.size(), inNodeItem.size() - outKey.size()));

        LOGD_DEBUG((demo, "GetNodeItem() outKey=%s, outValue=%s", outKey.c_str(), outValue.c_str()));
    }
    else
    {
        // set to empty string
        outValue = "";
    }
}

} } // namespace adit { namespace aauto
